@extends('partials.main')
@section('title')
    {{ 'Contact us' }}
@endsection
@section('content')
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
        }

        /* Add styles for the navbar */
        .navbar {
            display: flex;
            align-items: center;
            position: sticky;
            top: 0;
            background-color: #007bff;
            color: #fff;
            padding: 10px;
            z-index: 2;
        }

        .navbar-title {
            font-size: 20px;
            font-weight: bold;
            text-align: center !important;
            margin-left: auto;
            margin-right: auto;
        }

        .menu-dropdown {
            position: relative;
            display: inline-block;
            z-index: 3;
        }

        .menu-content {
            display: none;
            position: absolute;
            background-color: #007bff;
            min-width: 160px;
            box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
            z-index: 4;
            right: 0;
            max-width: calc(100vw - 10px);
        }

        .menu-dropdown:hover .menu-content {
            display: block;
        }

        .menu-content button {
            width: 100%;
            text-align: left;
            padding: 8px 12px;
            border: none;
            background-color: #fff;
            color: #000;
            cursor: pointer;
            width: 100%;
            max-width: 100%;
        }

        .menu-content button:hover {
            background-color: #fff;
        }

        .chat-section {
            position: sticky;
            top: 0;
            background-color: #f2f2f2;
            padding: 10px;
        }

        #chat-container {
            /* border: 1px solid #ddd; */
            padding: 10px;
            margin-bottom: 10px;
            max-height: calc(100vh - 100px);
            /* Adjust the height as per your needs */
            overflow-y: scroll;
            word-wrap: break-word;
            width: calc(100% - 22px);
            /* Adjust the width by accounting for the border and padding */
        }

        .user,
        .bot {
            margin-bottom: 5px;
            word-wrap: break-word;
            padding: 8px;
            border-radius: 5px;
        }

        .user {
            text-align: right;
            background-color: #007bff;
            color: #fff;
            margin-left: auto;
            align-self: flex-end;
            display: inline-flex;
        }

        .bot {
            text-align: left;
            background-color: #f2f2f2;
            color: #333;
            margin-right: auto;
        }

        #input-container {
            display: flex;
            align-items: center;
            padding: 10px;
            background-color: #f2f2f2;
        }

        #user-input {
            flex-grow: 1;
            padding: 5px;
            border: 1px solid #ddd;
            border-radius: 3px;
        }

        #send-button {
            margin-left: 10px;
            padding: 5px 10px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 3px;
            cursor: pointer;
        }

        #send-button:hover {
            background-color: #0056b3;
        }

        #settings-popup {
            display: none;
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-color: #f2f2f2;
            padding: 20px;
            z-index: 999;
        }

        #settings-popup input[type="text"] {
            margin-bottom: 10px;
            width: 100%;
            padding: 5px;
        }

        #settings-popup button {
            margin-right: 10px;
            padding: 5px 10px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 3px;
            cursor: pointer;
        }

        #settings-popup button:hover {
            background-color: #0056b3;
        }

        #close-button {
            position: absolute;
            top: 10px;
            right: 10px;
            padding: 5px 10px;
            background-color: #ccc;
            color: #fff;
            border: none;
            border-radius: 3px;
            cursor: pointer;
        }

        #close-button:hover {
            background-color: #999;
        }

        .typing-indicator {
            display: inline-block;
            animation: typing 1s infinite;
            font-size: 24px;
            color: #aaa;
            margin-left: 5px;
        }

        .timestamp {
            font-size: 12px;
            color: #999;
            margin-top: 4px;
        }

        @keyframes typing {
            0% {
                opacity: 0.3;
            }

            50% {
                opacity: 1;
            }

            100% {
                opacity: 0.3;
            }
        }

        .sug {
            border: 2px solid rgb(58, 55, 55);
            border-radius: 25px;
            padding: 10px;
        }
    </style>
    <!--************************************
                      Inner Banner Start
                    *************************************-->
    <section class="tg-parallax tg-innerbanner" data-appear-top-offset="600" data-parallax="scroll"
        data-image-src="../images/Home/aerial-view-doi-nang-non-mountains-thai-cave-tham-luang-chiang-rai-thailand.jpg">
        <div class="tg-sectionspace tg-haslayout">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <h1>Automated Tour Planner</h1>
                        <h2>Start your adventure today with Lanka Getaways!"</h2>
                        <ol class="tg-breadcrumb">
                            <li><a href="javascript:void(0);">Home</a></li>
                            <li class="tg-active">Automated Tour Planner</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--************************************
                      Inner Banner End
                    *************************************-->
    <!--************************************
                      Main Start
                    *************************************-->
    <main id="tg-main" class="tg-main tg-sectionspace tg-haslayout">
        <div class="container">
            <div class="row">
                <div>
                    <h2>Instruction</h2>
                    <h3>Ask Questions</h3>
                    <p>Feel free to ask any questions related to your trip, such as "What are the top attractions in Sri lanka?"
                        or "Can you recommend a budget hotel in Tokyo?"</p>

                    <h3>Provide Details</h3>
                    <p>To get more personalized recommendations, let us know your travel dates, budget, and any specific
                        preferences you have. </p>

                    <h3>Explore Destinations</h3>
                    <p>If you're not sure where you want to go, simply ask for destination suggestions, like "What are some
                        great places to visit in Sri Lanka?"</p>
                    </body>
                </div>
                <div class="chat-section">
                    <div id="chat-container"></div>
                    <div class="suggetion">
                        <small> Suggestion</small> <br>
                        <button class="sug" name="suggetion" type="submit" value="Four day itinerary in sri lanka">
                            Four day itinerary in sri lanka
                        </button>
                        <button class="sug" name="suggetion" type="submit" value="Best Places to visit in sri lanka">
                            Best Places to visit in sri lanka
                        </button>
                        <button class="sug" name="suggetion" type="submit"
                            value="What are the popular beaches in Sri Lanka?">
                            What are the popular beaches in Sri Lanka?
                        </button>
                        <button class="sug" name="suggetion" type="submit" value="is a sri Lanka  beautiful country?">
                            is a sri Lanka beautiful country?
                        </button>
                    </div>
                    <div id="input-container">
                        <input type="text" id="user-input" placeholder="Type your message here" />
                        <button id="send-button" disabled>Send</button>
                    </div>
                    <button style="padding-left: 10px" id="clear-button">Clear Conversation</button>
                </div>


            </div>
        </div>
    </main>
    <!--************************************
                      Main End
                    *************************************-->
    <script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
    <script>
        const chatContainer = document.getElementById("chat-container");
        const userInput = document.getElementById("user-input");
        const sendButton = document.getElementById("send-button");
        const apiUrl =
            "https://generativelanguage.googleapis.com/v1beta3/models/chat-bison-001:generateMessage?key=";
        const clearButton = document.getElementById("clear-button");
        const suggestionButtons = document.querySelectorAll(
            'button[name="suggetion"]'
        );
        sendButton.disabled = false;
        const conversationHistory =
            JSON.parse(localStorage.getItem("conversationHistory")) || [];

        conversationHistory.forEach(([message, sender, timestamp]) => {
            displayMessage(message, sender, timestamp);
        });
        suggestionButtons.forEach((button) => {
            button.addEventListener("click", () => {
                userInput.value = button.value;
                sendButton.disabled = false;
                sendButton.click();
            });
        });

        userInput.addEventListener("input", (event) => {
            sendButton.disabled = userInput.value.trim() === "";
        });

        userInput.addEventListener("keydown", (event) => {
            if (event.key === "Enter" && !event.shiftKey) {
                event.preventDefault();
                if (userInput.value.trim() !== "") {
                    sendButton.click();
                }
            }
        });

        sendButton.addEventListener("click", () => {
            const userMessage = userInput.value.trim();
            if (userMessage === "") {
                return;
            }
            userInput.value = "";

            const utimestamp = new Date().toLocaleTimeString();
            displayMessage(userMessage, "user", utimestamp);

            conversationHistory.push([userMessage, "user", utimestamp]);
            saveConversationHistory();
            sendUserMessage(userMessage);
            chatContainer.scrollTop = chatContainer.scrollHeight;
            window.scrollTo(0, document.body.scrollHeight);
        });

        clearButton.addEventListener("click", () => {
            clearConversation();
        });

        function displayMessage(message, sender, timestamp) {
            const messageElement = document.createElement("div");
            messageElement.classList.add(sender);
            if (sender === "bot") {
                message = marked.parse(message);
            }
            messageElement.innerHTML = message;
            chatContainer.appendChild(messageElement);

            const timestampElement = document.createElement("div");
            timestampElement.classList.add("timestamp");
            timestampElement.innerText = timestamp;
            chatContainer.appendChild(timestampElement);

            const lineElement = document.createElement("hr");
            chatContainer.appendChild(lineElement);

            chatContainer.scrollTop = chatContainer.scrollHeight;
            window.scrollTo(0, document.body.scrollHeight);
        }

        function clearConversation() {
            const confirmation = confirm(
                "Are you sure you want to clear the conversation?"
            );
            if (confirmation) {
                chatContainer.innerHTML = "";
                conversationHistory.length = 0;
                localStorage.removeItem("conversationHistory");
            }
        }

        function saveConversationHistory() {
            const formattedHistory = conversationHistory.map(
                ([message, sender]) => {
                    const timestamp = new Date().toLocaleTimeString();
                    return [message, sender, timestamp];
                }
            );
            localStorage.setItem(
                "conversationHistory",
                JSON.stringify(formattedHistory)
            );
        }

        function sendUserMessage(message) {
            const apiKey = "AIzaSyBGKce85OdGwWYbtmVrs3m_g24oaOLh55Q";
            if (!apiKey) {
                displayMessage(
                    "Please configure the API key in the settings.",
                    "bot"
                );
                return;
            }

            const requestUrl = apiUrl + apiKey;
            const requestBody = {
                prompt: {
                    messages: [{
                        content: message
                    }]
                },
                temperature: 0.1,
                candidate_count: 1,
            };

            const typingIndicator = document.createElement("span");
            typingIndicator.classList.add("typing-indicator");
            typingIndicator.innerText = "...";
            chatContainer.appendChild(typingIndicator);

            fetch(requestUrl, {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                    },
                    body: JSON.stringify(requestBody),
                })
                .then((response) => response.json())
                .then((data) => {
                    chatContainer.removeChild(typingIndicator);
                    const botResponse = data.candidates[0].content;
                    const btimestamp = new Date().toLocaleTimeString();
                    displayMessage(botResponse, "bot", btimestamp);
                    conversationHistory.push([botResponse, "bot", btimestamp]);
                    saveConversationHistory();
                })
                .catch((error) => {
                    chatContainer.removeChild(typingIndicator);
                    console.error("Error:", error);
                    displayMessage("An error occurred.", "bot");
                });
        }
    </script>
@endsection
